# CNN code for the paper



Code example for convolutional neural network training with symmetric padding and some comparision results

## Prerequisites
- CUDA + CuDNN
- Tensorflow (GPU version)
- python3
- tqdm


## Data
Download and generate cifar10 and cifar100 datasets:
```bash
cd data/cifar10/
python3 download_and_convert_cifar10.py
```
and
```bash
cd data/cifar100/
python3 download_and_convert_cifar100.py
```
For the imagenet dataset, please follow the instruction in 
https://github.com/tensorflow/models/tree/master/research/slim
## Config training devices
Change your configurations in the file `source/opt.py`
to use GPU0
```bash
gpu_list = [0]
```
to use GPU1 and GPU3
```bash
gpu_list = [1,3]
```



## Config training hyperparameters
Change your configurations in the file `source/opt.py`, please notice the comments between lines, which indicate most model settings in the paper


## Config network models
The key implementation of symmetric padding are in `source/net/net.py`

Change your configurations of network models in the file `source/nets/resnet_test.py` and `source/nets/densenet_test.py`, where the evaluation results in Fig 4, Table 1 and Table 2 can be reproduced by proper settings,
e.g., `mode`, `channel`.

Or you can add your own network files, don't forget to register them in `nets_factory.py`

You can also adjust and add other components, such as preprocessing, dataset, and register them in individual factory files.

## Train
Start training:
```bash
cd source/
python3 top.py
```
The training log files will be saved in `log/xxxx.txt`

You can check the training details in log files, and derive statistics for drawing curves.

And the model will be saved in `model/xxxx` if you have configured in `opt.py`
